#!/bin/bash
CURRENT_DIR=`dirname $0`

echo "####################"
echo "--> Executing script $0 $@"

set -e

unset -v DO_DEBUG

while getopts "s:d" opt; do
        case $opt in
            d) 
                export DO_DEBUG=true 
                ;;
            s) 
                export DEPLOY_STACK=$OPTARG 
                ;;
        esac
done

COMMON_CONFIG_FILE=${CURRENT_DIR}/../config/common.config

echo "trying to load loading config file ${COMMON_CONFIG_FILE}"
if [[ -f ${COMMON_CONFIG_FILE} ]];
then
  echo "loading config file ${COMMON_CONFIG_FILE}"
  . ${COMMON_CONFIG_FILE}
fi

STACK_CONFIG_FILE=${CURRENT_DIR}/../${DEPLOY_STACK}/stack.config

echo "trying to load loading config file ${STACK_CONFIG_FILE}"
if [[ -f ${STACK_CONFIG_FILE} ]];
then
  echo "loading config file ${STACK_CONFIG_FILE}"
  . ${STACK_CONFIG_FILE}
fi
