#!/bin/bash
CURRENT_DIR=`dirname $0`

echo "####################"
echo "--> Executing script $0 $@"

set -e

. ${CURRENT_DIR}/init.sh $@

if [[ -n ${DO_DEBUG} ]]
then
  docker-compose -f ${CURRENT_DIR}/../${DEPLOY_STACK}/docker-compose.yml config
else
  if [[ -n ${USE_HARBOR_KEY} ]] && [[ "${USE_HARBOR_KEY}" == "true" ]]
  then
    cat $HARBOR_KEY | docker login --username='${HARBOR_USER}' --password-stdin ${HARBOR_REGISTRY}
  fi

  if [[ -n ${STACK_NETWORK} ]]
  then
    # Create traefik_network if it does not exists
    docker network inspect ${STACK_NETWORK} >/dev/null 2>&1 || docker network create --opt encrypted -d overlay ${STACK_NETWORK}
  fi

  docker stack deploy --prune --with-registry-auth -c <(docker-compose -f ${CURRENT_DIR}/../${DEPLOY_STACK}/docker-compose.yml config) ${STACK_NAME}  
fi

